import flash.data.*;
import mx.controls.Alert;
import mx.events.CloseEvent;
import mx.collections.*;

private var conn:SQLConnection;
private var stmt:SQLStatement;


// ****************************************************************************
// アプリケーションの初期化
// ****************************************************************************
public function initData():void
{
	dbname.text = File.applicationDirectory.nativePath + "\\sampledb";
}

// ****************************************************************************
// 処理
// ****************************************************************************
public function ActionStart():void
{
	try {
		var target:File = new File(dbname.text);
	}
	catch (error:Error) {
		Alert.show("エラー:" + error.message,"",Alert.OK,null);
		return;
	}

	conn = new SQLConnection();

	if ( target.exists ) {
		try {
			conn.open( target );
			conn.loadSchema();
			this.setTreeData(toXMLListCollection(conn.getSchemaResult()));
			//conn.close();
		}
		catch (error:Error) {
			Alert.show("エラー:" + error.message,"",Alert.OK,null);
			return;
		}
		return;
	}

	stmt = new SQLStatement();

	try {
		conn.open( target );
		stmt.sqlConnection = conn;
		stmt.text = "create table jupitris ("
				  + " pid   integer,"
				  + " pname TEXT(50),"
				  + " pvar  TEXT(10),"
				  + " primary key(pid) )";
		stmt.execute();
		stmt.text = "insert into jupitris values("
				  + "1,"
				  + "'ネットワークペイント',"
				  + "'1.0.0'"
				  + ")";
		stmt.execute();
		stmt.text = "insert into jupitris values("
				  + "2,"
				  + "'小規模MMO',"
				  + "'0.1.0'"
				  + ")";
		stmt.execute();
		stmt.text = "insert into jupitris values("
				  + "3,"
				  + "'RPGエディタ',"
				  + "'0.1.3'"
				  + ")";
		stmt.execute();
		conn.loadSchema();
		this.setTreeData(toXMLListCollection(conn.getSchemaResult()));
		//con.close();
	}
	catch (error:Error) {
		Alert.show("エラー:" + error.message,"",Alert.OK);
		return;
	}
	Alert.show("サンプルデータベースを作成しました");
}

// ----------------------------------------------------------------------------
// ツリーに表示するラベル
// ----------------------------------------------------------------------------
private function treeLabel(item:Object):String
{
	var xml:XML = new XML(item);
	var ret:String = xml.localName();

	if(xml.attribute("dataType").length() != 0) {
		ret += " (" + xml.attribute("dataType") + ")";
	}
	return ret;
}

// ----------------------------------------------------------------------------
// ツリーにテーブルデータをセット
// ----------------------------------------------------------------------------
private function setTreeData(data:XMLListCollection):void {
	tree_shem.dataProvider = data;
	connect.visible = false;
	tableinfo.visible = true;
}

// ----------------------------------------------------------------------------
// スキーマ情報をXMLに変換する
// ----------------------------------------------------------------------------
private function toXMLListCollection(schm:SQLSchemaResult):XMLListCollection
{
	var list   : XMLDocument = new XMLDocument();

	for (var i:String in schm.tables) {
		var tblSchm : SQLTableSchema = schm.tables[i] as SQLTableSchema;
		var tblNode : XMLNode        = list.createElement(tblSchm.name);
		tblNode.attributes = tblSchm.sql;
		for (var j : String in tblSchm.columns) {
			var nchild:XMLNode = list.createElement(tblSchm.columns[j].name);
			nchild.attributes.dataType = tblSchm.columns[j].dataType;
			tblNode.appendChild(nchild);
		}
		list.appendChild(tblNode);
	}

	return new XMLListCollection(new XMLList(list));
}


private function execute():void {
    stmt = new SQLStatement();
    stmt.sqlConnection = conn;
    stmt.text = sql.text; //"SELECT * FROM syain";

    stmt.addEventListener(SQLEvent.RESULT, getDataResult);
//    stmt.addEventListener(SQLErrorEvent.ERROR, stmtErrorHandler);

    stmt.execute();
}

//SELECT処理結果
private function getDataResult(event:SQLEvent):void {
    status = " データグリッド更新 " + new Date();

    var result:SQLResult = stmt.getResult();

    if (result.data == null) {
    	dg.dataProvider = null;
    	return;
    }
    dg.dataProvider = new ArrayCollection(result.data);
}
